#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>

#include <list>

namespace maps::mrc::eye {


struct Cluster
{
    FrameDetectionIdSet detectionIds;
    // detectionIds that must not be added to this cluster
    FrameDetectionIdSet forbiddenDetectionIds;
};

using Clusters = std::list<Cluster>;
using ClusterIter = Clusters::iterator;

class ClusterStore {
public:
    typedef db::IdTo<ClusterIter>::const_iterator ConstIterator;
public:
    ClusterStore::ConstIterator find(db::TId detectionId) const;
    ClusterStore::ConstIterator begin() const;
    ClusterStore::ConstIterator end() const;

    void createNewCluster(FrameDetectionIdSet frameDetectionIds, FrameDetectionIdSet forbiddenDetectionIds = {});

    bool tryAddNewElementInCluster(ClusterIter cluster, const FrameDetectionId& fdId);
    bool tryAddNewElementInCluster(ClusterIter cluster, const FrameDetectionId& fdId0, const FrameDetectionId& fdId1);

    bool tryMergeTwoClusters(ClusterIter clusterIt0, ClusterIter clusterIt1);
    bool tryMergeTwoClustersAndNewElement(ClusterIter clusterIt0, ClusterIter clusterIt1, const FrameDetectionId& fdId);
    bool tryMergeThreeClusters(ClusterIter clusterIt0, ClusterIter clusterIt1, ClusterIter clusterIt2);

    std::vector<db::TIdSet> makeDetectionClusters();
private:
    Clusters clusters_;
    db::IdTo<ClusterIter> clusterByDetectionId_;

    void mergeTwoClusters(ClusterIter clusterIt0, ClusterIter clusterIt1);
};

void expandClustersByUnusedDetectionIds(db::TIdSet detectionIds, std::vector<db::TIdSet>& clusters);

ClusterStore makeClusterStoreConsistentWithMatchesVerdicts(
    const DetectionStore& store,
    const db::TIdSet& detectionIds,
    const MatchedFrameDetections& matches);

} // namespace maps::mrc::eye
