#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/utils.h>

namespace maps::mrc::eye {

bool hasCommonFrame(
    const FrameDetectionId& fdId,
    const FrameDetectionIdSet& fdIds)
{
    auto it = fdIds.lower_bound({fdId.frameId, 0});
    return it != fdIds.end() && it->frameId == fdId.frameId;
}

bool hasCommonFrame(
    const FrameDetectionIdSet& lhs,
    const FrameDetectionIdSet& rhs)
{
    auto lhsIt = lhs.begin();
    auto rhsIt = rhs.begin();
    while (lhsIt != lhs.end() and rhsIt != rhs.end()) {
        if (lhsIt->frameId < rhsIt->frameId) {
            ++lhsIt;
        } else if (lhsIt->frameId > rhsIt->frameId) {
            ++rhsIt;
        } else {
            return true;
        }
    }
    return false;
}

} // namespace maps::mrc::eye
