#pragma once
#include "visibility_predictor.h"

#include <maps/libs/geolib/include/line.h>

#include <catboost/libs/model/model.h>

#include <optional>

namespace maps::mrc::eye {

struct MatchEpilines
{
    geolib3::Line2 centerEpiline;
    geolib3::Line2 topLeftEpiline;
    geolib3::Line2 bottomRightEpiline;
};

MatchEpilines calcEpilines(
    FrameMatchPlace matchPlace,
    const cv::Mat& fundMatrix,
    const common::ImageBox& detectionBbox);


/// @param matches and @param @epilinesVec must have the same
/// size
std::vector<float> calcObjectVisibilityFactors(
    const common::Size& frameSize,
    const geolib3::Point2& frameMercPosition,
    geolib3::Heading frameHeading,
    const std::vector<DetectionMatchData>& matches,
    const std::vector<MatchEpilines>& epilinesVec
);

class CatboostClusterVisibilityPredictor : public ClusterVisibilityPredictor {
public:

    CatboostClusterVisibilityPredictor();

    bool isVisible(
        const common::Size& frameSize,
        const geolib3::Point2& frameMercPosition,
        geolib3::Heading frameHeading,
        const std::vector<DetectionMatchData>& matches
    ) const override;

private:
    TFullModel model_;
};

} // namespace maps::mrc::eye
