#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>

namespace maps::mrc::eye {

// Параметры по которым проводится проверка на возможность
// принадлежности двух детекций одному и тому же объекту.
// Считается, что две детекции могут принадлежать одному объекту,
// если детекции имеют одинаковый тип и аттрибуты,
// а также выполняются два условия:
//   distance(frameLocation1.location, frameLocation2.location) < distanceMeters,
//   angleDiff(frameLocation1.rotation, frameLocation2.rotation) < angleDiff,
//
// где frameLocation1, frameLocation2 позиции frame'ов для detection1 и
// detection2 соответственно.
struct MatchCandidatesParams {
    double distanceMeters;
    geolib3::Degrees angleEpsilon;
};

// Генерирует все возможные пары детекций, которые могут
// принадлежать одному и тому же физическому объекту.
// Детекции могут принадлежать одному объекту, если они
// удовлетворяют всем условиям, которые задаются в params.
// При этом рассматриваются все пары из декартового произведения
// двух множеств: detectionIds1 x detectionIds2.
// Однако, в получаемом массиве пар все пары уникальны с точностью
// до перестановки элементов внутри пары - если в массиве есть пара
// {detectionId1, detectionId2}, то пары {detectionId2, detectionId1}
// там уже точно не будет.
DetectionIdPairSet generateMatchCandidates(
    const DetectionStore& store,
    const db::TIdSet& detectionIds1,
    const db::TIdSet& detectionIds2,
    const MatchCandidatesParams& params);

} // namespace maps::mrc::eye
