#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>

namespace maps::mrc::eye {

// Разделяет множество детекций на подмножество детекций.
// В каждом из подмножеств детекции от одного deviceId.
std::vector<DetectionStore> splitByDeviceId(DetectionStore store);

// Параметры разбиения детекций на проезды
struct SplitPassageParams {
    double metersEpsilon;
    std::chrono::seconds secondsEpsilon;
};

// Разбиваем детекции на проезды
//   1) Сортируем frame'ы по времени
//   2) Идем последовательно по frame'мам,
//      frame относится к уже имеющемуся проезду,
//      если его параметры (и время, и положение) не
//      слишком сильно отличаются от параметров
//      предыдущего frame'а (по params)
//   3) Группируем детекции соотвественно фреймам
std::vector<DetectionStore> splitByPassages(
    DetectionStore store,
    const SplitPassageParams& params);

// Подгружаем объекты, которые находятся рядом с фреймами из store
// Для кажого фрейма подгружаем объекты, которые находятся внутри
// квадрата со сторогой 2 * radiusMeters и центром в позиции фрейма.
db::eye::Objects loadNeighboringObjects(
    pqxx::transaction_base& txn,
    const DetectionStore& store,
    double radiusMeters);

// Объединяет набор DetectionStore в один большой DetectionStore
DetectionStore mergeDetectionStores(std::vector<DetectionStore> stores);

// Разбивает входной store на проезды, учитывая параметры
// разбиения params. В каждом полученном проезде среди всех
// детекций (т.е. соответствующих frame'ов) вычисляем
// минимальное (minTime) и максимальное время (maxTime)
// и подгружаем все детекции по условию
// minTime - timePad <= time <= maxTime + timePad и
// deviceId == store.deviceId.
// Возвращает набор проездов, которые получились после подгрузки
// дополнительных детекций.
// После выполнения фунции, store будет содержать все входные
// детекции и детекции, которые добавились после подгрузки
// допольнительных детекций из проездов.
std::vector<db::TIdSet> makePassages(
    pqxx::transaction_base& txn,
    DetectionStore* storePtr,
    const SplitPassageParams& params,
    const std::chrono::seconds timePad);

} // namespace maps::mrc::eye
