#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/load.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/keypoints_matcher/include/superglue_matcher.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::mrc::eye {

struct MatchedKeypoints {
    db::TId frameId0;
    db::TId frameId1;
    std::vector<cv::Point2f> points0;
    std::vector<cv::Point2f> points1;
};

MatchedKeypoints getKeypointsMatch(
    const keypoints_matcher::SuperglueMatcher& matcher,
    const common::Keypoints& kpts0, double scale0,
    const common::Keypoints& kpts1, double scale1);

std::optional<FramesMatchData> getFrameMatch(
    std::vector<cv::Point2f> points0,
    std::vector<cv::Point2f> points1);

common::Keypoints filterPointsByMask(const common::Keypoints& kpts, const cv::Mat& mask);

class FrameSuperpointsMatcher : public FrameMatcher {
public:
    FrameSuperpointsMatcher(
        NYT::IClientBasePtr client,
        const FrameLoader& frameLoader,
        bool useGpu,
        std::optional<yt::PoolType> ytPoolType = std::nullopt,
        size_t ytConcurrency = 100);

    MatchedFramesPairs makeMatches(const DetectionStore& store, const std::vector<std::pair<db::TId, db::TId>>& frameIdPairs) const override;
private:
    NYT::IClientBasePtr client_;
    const FrameLoader& frameLoader_;
    bool useGpu_;
    std::optional<yt::PoolType> ytPoolType_;
    size_t ytConcurrency_;
};

class DetectionSuperpointsMatcher : public DetectionMatcher {
public:
    DetectionSuperpointsMatcher() = default;

    MatchedFrameDetections makeMatches(
        const DetectionStore& store,
        const DetectionIdPairSet& detectionPairs,
        const FrameMatcher* frameMatcherPtr) const override;

};

} // namespace maps::mrc::eye
