#pragma once

#include "match.h"
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>

namespace maps::mrc::eye {

/// Denotes the place of an image in Fund matrix
enum class FrameMatchPlace {
    First,
    Second
};

struct DetectionMatchData {
    FrameMatchPlace matchPlace;
    FramesMatchData match;
    geolib3::Point2 detectionFrameMercPosition;
    geolib3::Heading detectionFrameHeading;
    /// Detection bbox in frame in normal orientation
    common::ImageBox detectionBbox;
};

class ClusterVisibilityPredictor {
public:
    virtual ~ClusterVisibilityPredictor() = default;

    /// Determines if the the object represented by given detections
    /// should be visible on given frame
    /// @param clusterMatches contains matches between given frame and
    /// cluster detections frames
    /// @param frameSize -- frame size in normal orientation
    virtual bool isVisible(
        const common::Size& frameSize,
        const geolib3::Point2& frameMercPosition,
        geolib3::Heading frameHeading,
        const std::vector<DetectionMatchData>& matches
    ) const = 0;
};

class DummyVisibilityPredictor : public ClusterVisibilityPredictor {
public:

    DummyVisibilityPredictor(bool result = false)
        : result_(result)
    {}

    bool isVisible(
        const common::Size&,
        const geolib3::Point2&,
        geolib3::Heading,
        const std::vector<DetectionMatchData>&) const override
    {
        return result_;
    }
private:
    bool result_;
};

} // maps::mrc::eye
