#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/catboost_visibility_predictor.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>


#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::tests {

struct VisibilityPredictorFixture: public Fixture {
    VisibilityPredictorFixture();

    db::eye::Devices devices;
    db::eye::Frames frames;
    db::eye::FrameLocations locations;
    db::eye::FramePrivacies privacies;
    db::eye::DetectionGroups groups;
    db::eye::Detections detections;

    std::unique_ptr<DetectionStore> store;
    CatboostClusterVisibilityPredictor predictor;
};

VisibilityPredictorFixture::VisibilityPredictorFixture()
{
    devices = insertx<db::eye::DeviceGateway>(
        db::eye::Devices {
            {db::eye::MrcDeviceAttrs{""}}
        }
    );

    frames = insertx<db::eye::FrameGateway>(
        db::eye::Frames {
            {devices[0].id(), identical, makeUrlContext(1, "1"), {1200, 800}, time()},
            {devices[0].id(), identical, makeUrlContext(2, "2"), {1200, 800}, time()},
            {devices[0].id(), identical, makeUrlContext(3, "3"), {1200, 800}, time()},
            {devices[0].id(), identical, makeUrlContext(4, "4"), {1200, 800}, time()},
        }
    );

    locations = insertx<db::eye::FrameLocationGateway>(
        db::eye::FrameLocations {
            {frames[0].id(), geolib3::Point2{0, 0}, toRotation(geolib3::Heading(90), identical)},
            {frames[1].id(), geolib3::Point2{1, 0}, toRotation(geolib3::Heading(90), identical)},
            {frames[2].id(), geolib3::Point2{0, 2}, toRotation(geolib3::Heading(90), identical)},
            {frames[3].id(), geolib3::Point2{100, 100}, toRotation(geolib3::Heading(270), identical)},
        }
    );

    for (const auto& frame : frames) {
        privacies.emplace_back(frame.id(), db::FeaturePrivacy::Public);
    }
    privacies = insertx<db::eye::FramePrivacyGateway>(std::move(privacies));

    groups = insertx<db::eye::DetectionGroupGateway>(
        db::eye::DetectionGroups {
            {frames[0].id(), db::eye::DetectionType::HouseNumber},
            {frames[1].id(), db::eye::DetectionType::HouseNumber},
            {frames[2].id(), db::eye::DetectionType::HouseNumber},
            {frames[3].id(), db::eye::DetectionType::HouseNumber},
        }
    );

    detections = insertx<db::eye::DetectionGateway>(
        db::eye::Detections {
            {groups[0].id(), db::eye::DetectedHouseNumber{{100, 100, 200, 200}, 1.0, "12"}},
            {groups[1].id(), db::eye::DetectedHouseNumber{{100, 100, 200, 200}, 1.0, "12"}},
            {groups[2].id(), db::eye::DetectedHouseNumber{{100, 100, 200, 200}, 1.0, "12"}},
            {groups[3].id(), db::eye::DetectedHouseNumber{{100, 100, 200, 200}, 1.0, "12"}},
        }
    );

    store = std::make_unique<DetectionStore>(
        byId(groups),
        byId(detections),
        byId(frames),
        byId(locations),
        byId(privacies),
        byId(devices)
    );
};

Y_UNIT_TEST_SUITE_F(catboost_predictor, VisibilityPredictorFixture)
{

Y_UNIT_TEST(empty_matches)
{
    const size_t frameIdx = 0;
    EXPECT_FALSE(predictor.isVisible(
        frames[frameIdx].size(),
        locations[frameIdx].mercatorPos(),
        eye::decomposeRotation(locations[frameIdx].rotation()).heading,
        {}
    ));
}

} // Y_UNIT_TEST_SUITE_F

} // namespace maps::mrc::eye::tests
