OWNER(g:maps-mrc)

LIBRARY(mrc_eye_detection)

PEERDIR(
    contrib/restricted/boost
    contrib/libs/opencv
    library/cpp/iterator
    catboost/libs/model

    maps/libs/common
    maps/libs/geolib

    maps/wikimap/mapspro/libs/common
    maps/wikimap/mapspro/services/mrc/libs/db
    maps/wikimap/mapspro/services/mrc/libs/carsegm
    maps/wikimap/mapspro/services/mrc/libs/keypoints_matcher
    maps/wikimap/mapspro/services/mrc/libs/object
    maps/wikimap/mapspro/services/mrc/libs/superpoint
    maps/wikimap/mapspro/services/mrc/libs/traffic_signs
    maps/wikimap/mapspro/services/mrc/libs/yt
    maps/wikimap/mapspro/services/mrc/eye/lib/common
    maps/wikimap/mapspro/services/mrc/eye/lib/location

    mapreduce/yt/interface
    mapreduce/yt/util
)

SRCS(
    impl/catboost_visibility_predictor.cpp
    impl/cluster_store.cpp
    impl/greedy_clusterizer.cpp
    impl/match_candidates.cpp
    impl/match.cpp
    impl/position_clusterizer.cpp
    impl/position_matcher.cpp
    impl/store_utils.cpp
    impl/store.cpp
    impl/superpoints_match.cpp
    impl/triangles_clusterizer.cpp
    impl/utils.cpp
    impl/yt_serialization.cpp
)


FROM_SANDBOX(
    FILE 3266496894
    OUT_NOAUTO model.bin
)

RESOURCE (
    model.bin /maps/mrc/predict_visibility/model.bin
)

END()

RECURSE_FOR_TESTS(tests)
