#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/feedback_url.h>

namespace maps::mrc::eye {

FeedbackUrlResolver::FeedbackUrlResolver(
    const http::URL& socialUrl)
    : socialUrl_(socialUrl)
{
}

std::string FeedbackUrlResolver::url(db::eye::HypothesisType type) const {
    static const std::unordered_map<db::eye::HypothesisType, std::string> TYPE_TO_PATH{
        {db::eye::HypothesisType::AbsentTrafficLight, "/feedback/tasks/absent-traffic-light"},
        {db::eye::HypothesisType::AbsentHouseNumber, "/feedback/tasks/absent-address"},
        {db::eye::HypothesisType::WrongSpeedLimit, "/feedback/tasks/speed-limit"},
        {db::eye::HypothesisType::AbsentParking, "/feedback/tasks/parking"},
        {db::eye::HypothesisType::WrongParkingFtType, "/feedback/tasks/parking-ft-type"},
        {db::eye::HypothesisType::TrafficSign, "/feedback/tasks/traffic-sign"},
        {db::eye::HypothesisType::WrongDirection, "/feedback/tasks/road-direction"},
        {db::eye::HypothesisType::ProhibitedPath, "/feedback/tasks/prohibited-path"},
        {db::eye::HypothesisType::LaneHypothesis, "/feedback/tasks/traffic-sign"},
        {db::eye::HypothesisType::SpeedBump, "/feedback/tasks/speed-bump"},
    };

    http::URL url = socialUrl_;

    auto pathIt = TYPE_TO_PATH.find(type);
    if (pathIt != TYPE_TO_PATH.end()) {
        url.setPath(pathIt->second);
    } else {
        throw RuntimeError() << "Invalid hypothesis type to push " << type;
    }

    return url.toString();
}

} // namespace maps::mrc::eye
