#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/privacy.h>

namespace maps::mrc::eye {

namespace {

static const std::string HIDDEN = "hidden";
static const std::string INTERNAL_CONTENT = "internalContent";

bool isHiddenHypothesisType(db::eye::HypothesisType type) {
    static const std::set<db::eye::HypothesisType> HIDDEN_HYPOTHESIS_TYPES{
        db::eye::HypothesisType::TrafficSign,
        db::eye::HypothesisType::ProhibitedPath,
        db::eye::HypothesisType::AbsentTrafficLight,
        db::eye::HypothesisType::AbsentHouseNumber,
    };
    return HIDDEN_HYPOTHESIS_TYPES.count(type);
}

} // namespace

void setHypothesisPrivacy(
    const db::eye::Hypothesis& hypothesis,
    const HypothesisContext& context,
    json::ObjectBuilder obj)
{
    REQUIRE(!context.empty(), "Source context may not be empty");

    db::FeaturePrivacy privacy = db::FeaturePrivacy::Public;
    for (const auto& item : context.items()) {
        privacy = db::selectStricterPrivacy(privacy, item.framePrivacy.type());
    }

    if (isHiddenHypothesisType(hypothesis.type())) {
        privacy = db::selectStricterPrivacy(privacy, db::FeaturePrivacy::Restricted);
    }

    switch(privacy) {
        case db::FeaturePrivacy::Public:
            obj[HIDDEN] = false;
            return;
        case db::FeaturePrivacy::Restricted:
            obj[HIDDEN] = true;
            return;
        case db::FeaturePrivacy::Secret:
            obj[HIDDEN] = true;
            obj[INTERNAL_CONTENT] = true;
            return;
        default:
            throw maps::RuntimeError() << "Unknown frame privacy " << privacy;
    }
}

} // namespace maps::mrc::eye
