#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/revision.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>

namespace maps::mrc::eye {

namespace {

void dumpObjectIdAndCommitIdToJson(
    const wiki::revision::RevisionID& revisionId,
    json::ObjectBuilder obj)
{
    if (!revisionId.empty()) {
        obj["objectId"] = std::to_string(revisionId.objectId());
        obj["commitId"] = std::to_string(revisionId.commitId());
    }
}

void dumpRevisionIdToJson(
    const wiki::revision::RevisionID& revisionId,
    json::ObjectBuilder obj)
{
    if (!revisionId.empty()) {
        obj["revisionId"] = std::to_string(revisionId.objectId()) + ":" + std::to_string(revisionId.commitId());
    }
}

} // namespace

void setObjectIdAndCommitId(
    const db::eye::Hypothesis& hypothesis,
    json::ObjectBuilder obj)
{
    if (auto revisionId = getRevisionId(hypothesis)) {
        dumpObjectIdAndCommitIdToJson(revisionId.value(), obj);
    }
}

void setRevisionId(
    const db::eye::Hypothesis& hypothesis,
    json::ObjectBuilder obj)
{
    if (auto revisionId = getRevisionId(hypothesis)) {
        dumpRevisionIdToJson(revisionId.value(), obj);
    }
}

} // namespace maps::mrc::eye
