#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/serialize.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/revision.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/privacy.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/hypothesis_attrs.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/source_context.h>

namespace maps::mrc::eye {

std::string serialize(
    const db::eye::Hypothesis& hypothesis,
    const HypothesisContext& context,
    const FrameUrlResolver& frameUrl)
{
    json::Builder builder;
    builder << [&](json::ObjectBuilder obj) {
        obj["source"] = "mrc";
        obj["workflow"] = "task";

        setObjectIdAndCommitId(hypothesis, obj);
        setHypothesisPrivacy(hypothesis, context, obj);
        setHypothesisAttrs(hypothesis, obj);

        obj["position"] = geolib3::geojson(hypothesis.geodeticPos());

        obj["sourceContext"] = [&](json::ObjectBuilder sourceContext) {
            serializeSourceContext(hypothesis, context, frameUrl, sourceContext);
        };
    };
    return builder.str();
}

} // namespace maps::mrc::eye
