#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/feedback_url.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/url.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

namespace maps::mrc::eye {

struct PushFeedbackConfig {
    MrcWorkerConfig mrc;

    FrameUrlResolver* frameUrlResolver{nullptr};
    FeedbackUrlResolver* feedbackUrlResolver{nullptr};
    privacy::GeoIdProviderPtr geoIdProvider{nullptr};
    db::eye::HypothesisTypes hypothesisTypes;
    bool approveInToloka;
    bool pushToSocial;
};

bool isValid(const PushFeedbackConfig& config);

} // namespace maps::mrc::eye
