#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/hypothesis_store.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>

namespace maps::mrc::eye {

struct PushFeedbackWorkerResult {
    std::vector<std::pair<db::eye::Hypothesis, HypothesisContext>> hypothesesToPublish;
    // новые задания в толоке, которые необходимы для валидации гипотез
    db::eye::Recognitions recognitionRequests;
};

class PushFeedbackWorker
    : public BaseMrcWorkerWithConfig<
        PushFeedbackConfig,
        common::LockId::EyePushFeedback>
{
public:
    PushFeedbackWorker(const PushFeedbackConfig& config)
        : BaseMrcWorkerWithConfig(config)
    {
        REQUIRE(isValid(config_), "Invalid config!");
    }

    void processBatch(const db::TIds& hypothesisIds);

    bool processBatchInLoopMode(size_t batchSize);

private:
    PushFeedbackWorkerResult process(const HypothesisStore& store) const;

    db::eye::Recognitions removeDuplicate(
        pqxx::transaction_base& readTxn,
        db::eye::Recognitions recognitions);

    void saveTolokaRequests(
        pqxx::transaction_base& readTxn,
        pqxx::transaction_base& writeTxn,
        db::eye::Recognitions& tolokaRequests);

    void pushHypotheses(
        const std::vector<std::pair<db::eye::Hypothesis, HypothesisContext>>& hypothesesToPuplish);

    void updateMetadata(db::TId endTxnId);
};

} // namespace maps::mrc::eye
