#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/tests/mock_geo_id_provider.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, base_test)
{
    PushFeedbackConfig config;

    EXPECT_FALSE(isValid(config));

    EXPECT_EQ(config.mrc.lockFree, false);
    EXPECT_EQ(config.mrc.commit, false);
    EXPECT_TRUE(config.hypothesisTypes.empty());

    FrameUrlResolver makeFrameUrl("http://www.browser.ru", "http://www.browser-pro.ru");
    FeedbackUrlResolver makeSocialUrl("http://social.ru");
    config.mrc.lockFree = false;
    config.mrc.commit = true;
    config.mrc.pool = &pool();
    config.hypothesisTypes = {db::eye::HypothesisType::AbsentTrafficLight};
    config.frameUrlResolver = &makeFrameUrl;
    config.feedbackUrlResolver = &makeSocialUrl;
    config.geoIdProvider = makeMockGeoIdProvider();

    EXPECT_TRUE(isValid(config));

    EXPECT_EQ(config.mrc.lockFree, false);
    EXPECT_EQ(config.mrc.commit, true);
    EXPECT_EQ(config.mrc.pool, &pool());
    EXPECT_EQ(
        config.hypothesisTypes,
        db::eye::HypothesisTypes{db::eye::HypothesisType::AbsentTrafficLight}
    );
    EXPECT_EQ(config.frameUrlResolver, &makeFrameUrl);
    EXPECT_EQ(config.feedbackUrlResolver, &makeSocialUrl);
}

} // namespace maps::mrc::eye::tests
