#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/include/feedback_url.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/feedback/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST(feedback_url_tests, resolve_absent_traffic_light_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::AbsentTrafficLight);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/absent-traffic-light"
    );
}

TEST(feedback_url_tests, resolve_absent_house_number_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::AbsentHouseNumber);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/absent-address"
    );
}

TEST(feedback_url_tests, resolve_wrong_speed_limit_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::WrongSpeedLimit);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/speed-limit"
    );
}

TEST(feedback_url_tests, resolve_absent_parking_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::AbsentParking);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/parking"
    );
}

TEST(feedback_url_tests, resolve_wrong_parking_ft_type_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::WrongParkingFtType);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/parking-ft-type"
    );
}

TEST(feedback_url_tests, resolve_traffic_sign_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::TrafficSign);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/traffic-sign"
    );
}

TEST(feedback_url_tests, resolve_wrong_direction_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::WrongDirection);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/road-direction"
    );
}

TEST(feedback_url_tests, resolve_prohibited_path_feedback_url_test)
{
    const http::URL socialUrl("http://social.ru");
    const FeedbackUrlResolver feedbackUrlResolver(socialUrl);

    http::URL url = feedbackUrlResolver.url(db::eye::HypothesisType::ProhibitedPath);

    EXPECT_EQ(
        url.toString(),
        "http://social.ru/feedback/tasks/prohibited-path"
    );
}

} // namespace maps::mrc::eye::tests
