#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::eye {

struct MockGeoIdProvider: public privacy::GeoIdProvider {
    MOCK_METHOD(db::TIds, load, (const geolib3::BoundingBox&), (const, override));
    MOCK_METHOD(geolib3::MultiPolygon2, geomById, (db::TId geoId), (const, override));

    db::TIds load(const geolib3::Point2& geoPoint) const override {
        static const db::TId RUSSIA_GEO_ID = 225;
        static const double MOCK_RUSSIA_MIN_X = 42;
        static const double MOCK_RUSSIA_MAX_X = 44;
        static const double MOCK_RUSSIA_MIN_Y = 56;
        static const double MOCK_RUSSIA_MAX_Y = 58;

        if (MOCK_RUSSIA_MIN_X <= geoPoint.x() && geoPoint.x() <= MOCK_RUSSIA_MAX_X &&
            MOCK_RUSSIA_MIN_Y <= geoPoint.y() && geoPoint.y() <= MOCK_RUSSIA_MAX_Y)
        {
            return {RUSSIA_GEO_ID};
        } else {
            return {};
        }
    }
};

inline auto makeMockGeoIdProvider() {
    return std::make_unique<MockGeoIdProvider>();
}

} // namespace maps::mrc::eye
