#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_absent_house_number/include/generator.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/common.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>

#include <maps/wikimap/mapspro/services/mrc/libs/addr_pt_searcher/include/addr_pt_searcher.h>
#include <maps/wikimap/mapspro/services/mrc/libs/house_number_sign_detector/include/house_number_sign_detector.h>

#include <mutex>

namespace maps::mrc::eye {

namespace {

std::set<char16_t> getRecognizerSupportedSymbols() {
    static std::once_flag flag;
    static std::set<char16_t> symbols;
    std::call_once(flag, [&]{
        std::vector<char16_t> symbolsVec
            = house_number_sign_detector::makeHouseNumberRecognizer().getSupportedSymbols();
        symbols = {symbolsVec.begin(), symbolsVec.end()};
    });
    return symbols;
}

} // namespace


bool AbsentHouseNumberGeneratorImpl::appliesToObject(const db::eye::Object&)
{
    // Сразу загружаются объекты с типом db::eye::ObjectType::HouseNumber,
    // поэтому тут не нужны дополнительные проверки
    return true;
}

bool AbsentHouseNumberGeneratorImpl::hasDuplicate(
    pqxx::transaction_base& txn,
    const db::eye::Hypothesis& hypothesis,
    db::TId /*obejctId*/)
{
    constexpr double SEARCH_RADIUS_METERS = 30.;
    return hasDuplicateDefaultCheck(txn, hypothesis, SEARCH_RADIUS_METERS);
}

db::eye::Hypotheses AbsentHouseNumberGeneratorImpl::validate(
    const db::eye::Object& object,
    const db::eye::ObjectLocation& location,
    const db::eye::Objects& /*slaveObjects*/,
    object::Loader& loader)
{
    constexpr double MIN_CONFIDENCE = 0.7;

    addr_pt_searcher::AddressPointSearcher addrPtSearcher(
        loader, getRecognizerSupportedSymbols()
    );
    addrPtSearcher.resetPosition(location.mercatorPos());

    bool hasCandidate
        = addrPtSearcher.hasCandidate(
            location.mercatorPos(),
            object.attrs<db::eye::HouseNumberAttrs>().number.c_str(),
            MIN_CONFIDENCE
        );

    if (!hasCandidate) {
        return {
            db::eye::Hypothesis(
                location.mercatorPos(),
                db::eye::AbsentHouseNumberAttrs{
                    object.attrs<db::eye::HouseNumberAttrs>().number
                }
            )
        };
    } else {
        return {};
    }
}

} // namespace maps::mrc::eye
