#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/generator.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_absent_traffic_light/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_gateway.h>

namespace maps::mrc::eye {

using AbsentTrafficLightGeneratorConfig = HypothesisGeneratorConfig;

struct AbsentTrafficLightGeneratorImpl {
    static bool appliesToObject(const db::eye::Object& object);

    static bool hasDuplicate(
        pqxx::transaction_base& txn,
        const db::eye::Hypothesis& hypothesis,
        db::TId objectId);

    static db::eye::Hypotheses validate(
        const db::eye::Object& object,
        const db::eye::ObjectLocation& location,
        const db::eye::Objects& slaveObjects,
        object::Loader& loader);
};

using AbsentTrafficLightGenerator
    = BaseHypothesisGenerator<
        AbsentTrafficLightGeneratorImpl,
        absentTrafficLightMetadata,
        db::eye::ObjectType::TrafficLight,
        common::LockId::EyeGenerateAbsentTrafficLight>;

} // namespace maps::mrc::eye
