#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/geom.h>

#include <maps/libs/geolib/include/conversion.h>

namespace maps::mrc::eye {

geolib3::Polyline2 cutFromStart(const geolib3::Polyline2& mercatorPolyline, double lengthMeters)
{
    if (!mercatorPolyline.pointsNumber()) {
        return {};
    }

    geolib3::PointsVector result{mercatorPolyline.points().front()};

    const double maxLength = geolib3::toMercatorUnits(lengthMeters, result.front());
    double totalLength = 0;

    for (const auto& segment: mercatorPolyline.segments()) {
        const double length = geolib3::length(segment);
        totalLength += length;

        constexpr double epsilon = 1e-3;

        if (totalLength > maxLength + epsilon) {
            const double diff = totalLength - maxLength;
            result.push_back(segment.pointByPosition(1 - diff / length));
            break;
        }

        result.push_back(segment.end());
    }

    return geolib3::Polyline2(result);
}

geolib3::Polyline2 cutFromEnd(const geolib3::Polyline2& mercatorPolyline, double lengthMeters)
{
    const auto& points = mercatorPolyline.points();

    auto result = cutFromStart(
        geolib3::Polyline2{points.rbegin(), points.rend()},
        lengthMeters
    );

    result.reverse();

    return result;
}

} // namespace maps::mrc::eye
