#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/load.h>

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/parking.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/rd.h>

namespace maps::mrc::eye {

template<>
object::RoadJunctions load(object::Loader& loader, const geolib3::BoundingBox& mercatorBox)
{
    return loader.loadRoadJunctions(mercatorBox);
}

template<>
object::RoadJunctions load(object::Loader& loader, const object::TIds& ids)
{
    return loader.loadRoadJunctions(ids);
}

template<>
object::RoadElements load(object::Loader& loader, const geolib3::BoundingBox& mercatorBox)
{
    return loader.loadRoadElements(mercatorBox);
}

template<>
object::RoadElements load(object::Loader& loader, const object::TIds& ids)
{
    return loader.loadRoadElements(ids);
}

template<>
object::Conditions load(object::Loader& loader, const object::TIds& ids)
{
    return loader.loadConditions(ids);
}

template<>
object::ParkingLots load(object::Loader& loader, const geolib3::BoundingBox& mercatorBox)
{
    return loader.loadParkingLots(mercatorBox);
}

template<>
object::ParkingLots load(object::Loader& loader, const object::TIds& ids)
{
    return loader.loadParkingLots(ids);
}

template<>
object::LinearParkingLots load(object::Loader& loader, const geolib3::BoundingBox& mercatorBox)
{
    return loader.loadLinearParkingLots(mercatorBox);
}

template<>
object::LinearParkingLots load(object::Loader& loader, const object::TIds& ids)
{
    return loader.loadLinearParkingLots(ids);
}

} // namespace maps::mrc::eye
