#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>

#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/units.h>

namespace maps::mrc::eye {

class DirectedPoint {

public:
    DirectedPoint(geolib3::Heading direction, const geolib3::Point2& mercator);

    DirectedPoint(const db::eye::ObjectLocation& location);

    geolib3::Heading heading() const;

    geolib3::Point2 mercator() const;
    geolib3::Point2 geo() const;

    DirectedPoint moveForward(double meters) const;
    DirectedPoint rotateClockwise(geolib3::Degrees angle) const;
    DirectedPoint reverse() const;

private:
    geolib3::Heading heading_;
    geolib3::Point2 mercator_;
};

} // namespace maps::mrc::eye
