#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <boost/range/algorithm_ext.hpp>

#include <vector>

namespace maps::mrc::eye {

template<typename TObject>
std::vector<TObject> load(
        object::Loader& loader,
        const geolib3::BoundingBox& mercatorBox);

template<typename TObject>
std::vector<TObject> load(
        object::Loader& loader,
        const object::TIds& ids);

template<typename TObject, typename Filter>
std::vector<TObject> load(
        object::Loader& loader,
        const geolib3::BoundingBox& mercatorBox,
        Filter filter)
{
    auto objects = load<TObject>(loader, mercatorBox);

    boost::remove_erase_if(
        objects,
        [&](const TObject& object) {
            return !filter(object);
        }
    );

    return objects;
}

template<typename TObject, typename Filter>
std::vector<TObject> load(
        object::Loader& loader,
        const object::TIds& ids,
        Filter filter)
{
    auto objects = load<TObject>(loader, ids);

    boost::remove_erase_if(
        objects,
        [&](const TObject& object) {
            return !filter(object);
        }
    );

    return objects;
}

} // namespace maps::mrc::eye
