#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/metadata.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::eye {

class HypothesisGeneratorMetadataManager: public MetadataManagerBase {
public:
    HypothesisGeneratorMetadataManager(std::string name, pqxx::transaction_base& txn)
        : MetadataManagerBase(name, txn)
    {}

    void updateObjectTxnId(db::TId txnId) {
        const auto key = objectTxnIdKey();

        INFO() << "Update metadata " << key << " " << txnId;
        gateway().upsertByKey(key, std::to_string(txnId));
    }

    db::TId getObjectTxnId() {
        return gateway().tryLoadByKey<db::TId>(objectTxnIdKey(), 0);
    }

    void updateObjectRelTxnId(db::TId txnId) {
        const auto key = objectRelTxnIdKey();

        INFO() << "Update metadata " << key << " " << txnId;
        gateway().upsertByKey(key, std::to_string(txnId));
    }

    db::TId getObjectRelTxnId() {
        return gateway().tryLoadByKey<db::TId>(objectRelTxnIdKey(), 0);
    }

private:
    std::string objectTxnIdKey() const {
        return fullKey("object_txn_id");
    }
    std::string objectRelTxnIdKey() const {
        return fullKey("object_relation_txn_id");
    }
};

} // namespace maps::mrc::eye
