#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/generator.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_gateway.h>

namespace maps::mrc::eye::tests {

// use traffic light as simple object
struct ExampleGenerator {
    static bool appliesToObject(const db::eye::Object&)
    {
        return true;
    }

    static db::eye::Hypotheses validate(
        const db::eye::Object& /*object*/,
        const db::eye::ObjectLocation& location,
        const db::eye::Objects& /*slaveObjects*/,
        object::Loader& /*loader*/)
    {
        return {
            db::eye::Hypothesis(
                location.mercatorPos(),
                db::eye::AbsentTrafficLightAttrs()
            )
        };
    }

    static bool hasDuplicate(
        pqxx::transaction_base& /*txn*/,
        const db::eye::Hypothesis& /*hypothesis*/,
        db::TId /*objectId*/)
    {
        return false;
    }
};

HypothesisGeneratorMetadataManager exampleMetadata(pqxx::transaction_base& txn) { return {"test", txn}; }

using ExampleHypothesisGenerator
    = BaseHypothesisGenerator<
        ExampleGenerator,
        exampleMetadata,
        db::eye::ObjectType::TrafficLight,
        common::LockId::EyeGenerateAbsentTrafficLight>;

} // namespace maps::mrc::eye::tests
