#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/common.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST(common_tests, object_point_searcher)
{
    std::vector<int> objects = {1, 3, 5, 7, 9};
    GeometrySearcher<geolib3::Point2, size_t> searcher;
    for (size_t i = 0; i < objects.size(); i++) {
        geolib3::Point2 pt(objects[i], objects[i]);
        searcher.insert(pt, i);
    }
    searcher.build();

    auto searchResult = searcher.find(
        geolib3::BoundingBox(geolib3::Point2(5., 5.), 4.5, 4.5)
    );

    std::vector<int> result;
    for (auto it = searchResult.first; it != searchResult.second; it++) {
        result.push_back(objects[it->value()]);
    }

    const std::vector<int> expectedResult = {3, 5, 7};
    std::sort(result.begin(), result.end());

    EXPECT_EQ(result, expectedResult);
}

TEST(common_tests, objects_context_test)
{
    const db::eye::Objects objects{
        {1u, TrafficLightAttrs()},
    };

    const db::eye::ObjectLocations locations{
        {0u, geolib3::Point2(0., 0.), Eigen::Quaterniond::Identity()},
    };

    const std::map<db::TId, db::TIds> relations;

    const db::eye::Objects slaveObjects;

    const ObjectsContext context(objects, locations, relations, slaveObjects);

    EXPECT_EQ(context.size(), 1u);
}

} // namespace maps::mrc::eye::tests
