#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/tests/fixture.h>

namespace maps::mrc::eye::tests {

MrcFixture::MrcFixture() {
    auto txn = pool().masterWriteableTransaction();

    devices = {
        db::eye::Device(db::eye::MrcDeviceAttrs{"M1"}),
    };
    db::eye::DeviceGateway(*txn).insertx(devices);

    frames = {
        {
            devices[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            db::eye::MrcUrlContext{1, "1", "1"},
            {1280, 720},
            chrono::parseSqlDateTime("2017-05-06 07:01:15+03")
        },
    };
    db::eye::FrameGateway(*txn).insertx(frames);

    detectionGroups = {
        {
            frames[0].id(),
            db::eye::DetectionType::TrafficLight
        },
    };
    db::eye::DetectionGroupGateway(*txn).insertx(detectionGroups);

    detections = {
        {
            detectionGroups[0].id(),
            db::eye::DetectedTrafficLights {
                db::eye::DetectedTrafficLight {
                    common::ImageBox(100, 100, 200, 200),
                    0.98
                }
            }
        },
    };
    db::eye::DetectionGateway(*txn).insertx(detections);

    objects = {
        {
            detections[0].id(),
            db::eye::TrafficLightAttrs()
        },
    };
    db::eye::ObjectGateway(*txn).insertx(objects);

    locations = {
        {objects[0].id(), geolib3::Point2(1., 2.), Eigen::Quaterniond::Identity()},
    };
    db::eye::ObjectLocationGateway(*txn).insertx(locations);

    txn->commit();
}

} // namespace maps::mrc::eye::tests
