#pragma once

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/arcadia.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/playground.h>
#include <yandex/maps/mrc/unittest/local_server.h>

namespace maps::mrc::eye::tests {

struct MrcFixture : unittest::WithUnittestConfig<unittest::DatabaseFixture>
{
    MrcFixture();

    db::eye::Devices devices;
    db::eye::Frames frames;
    db::eye::DetectionGroups detectionGroups;
    db::eye::Detections detections;
    db::eye::Objects objects;
    db::eye::ObjectLocations locations;
};

class Fixture : public testing::Test {
public:
    Fixture() = default;

    auto& mrcPool() { return mrcFixture.pool(); }

    auto& wikiPool() { return wikiFixture.pool(); }

    db::eye::Objects& eyeObjects() { return mrcFixture.objects; }

    db::eye::ObjectLocations& eyeLocations() { return mrcFixture.locations; }

private:
    MrcFixture mrcFixture;
    wiki::unittest::ArcadiaDbFixture wikiFixture;

};

} // namespace maps::mrc::eye::tests

