#include <maps/libs/geolib/include/test_tools/comparison.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/generator.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/tests/common.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, example_process_test)
{
    HypothesisGeneratorConfig config;
    config.mrc.commit = true;
    config.mrc.lockFree = true;
    config.mrc.pool = &mrcPool();
    config.wiki.pool = &wikiPool();
    config.wiki.concurrency = 1;

    ExampleHypothesisGenerator generator(config);

    generator.processBatch({eyeObjects()[0].id()});

    db::eye::HypothesisObjects hypothesisObjects
        = db::eye::HypothesisObjectGateway(*mrcPool().masterWriteableTransaction()).load(
            db::eye::table::HypothesisObject::objectId == eyeObjects()[0].id()
        );
    ASSERT_EQ(hypothesisObjects.size(), 1u);

    const db::eye::HypothesisObject& hypothesisObject = hypothesisObjects[0];

    db::TId hypothesisId = hypothesisObject.hypothesisId();

    db::eye::Hypothesis hypothesis
        = db::eye::HypothesisGateway(*mrcPool().masterWriteableTransaction()).loadById(hypothesisId);

    EXPECT_EQ(hypothesis.type(), db::eye::HypothesisType::AbsentTrafficLight);
    EXPECT_TRUE(
        geolib3::test_tools::approximateEqual(
            hypothesis.mercatorPos(),
            eyeLocations()[0].mercatorPos(), geolib3::EPS)
    );
}

TEST_F(Fixture, example_process_batch_test)
{
    HypothesisGeneratorConfig config;
    config.mrc.commit = true;
    config.mrc.lockFree = true;
    config.mrc.pool = &mrcPool();
    config.wiki.pool = &wikiPool();
    config.wiki.concurrency = 1;

    ExampleHypothesisGenerator generator(config);

    EXPECT_EQ(generator.processBatchInLoopMode(2u), true);

    db::eye::HypothesisObjects hypothesisObjects
        = db::eye::HypothesisObjectGateway(*mrcPool().masterWriteableTransaction()).load(
            db::eye::table::HypothesisObject::objectId == eyeObjects()[0].id()
        );
    ASSERT_EQ(hypothesisObjects.size(), 1u);

    const db::eye::HypothesisObject& hypothesisObject = hypothesisObjects[0];

    db::TId hypothesisId = hypothesisObject.hypothesisId();

    db::eye::Hypothesis hypothesis
        = db::eye::HypothesisGateway(*mrcPool().masterWriteableTransaction()).loadById(hypothesisId);

    EXPECT_EQ(hypothesis.type(), db::eye::HypothesisType::AbsentTrafficLight);
    EXPECT_TRUE(
        geolib3::test_tools::approximateEqual(
            hypothesis.mercatorPos(),
            eyeLocations()[0].mercatorPos(), geolib3::EPS)
    );
}

} // namespace maps::mrc::eye::tests
