#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/generator.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_lane_hypothesis/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_gateway.h>

namespace maps::mrc::eye {

using LaneHypothesisGeneratorConfig = HypothesisGeneratorConfig;

struct LaneHypothesisGeneratorImpl {
    static bool appliesToObject(const db::eye::Object& object);

    static bool hasDuplicate(
        pqxx::transaction_base& txn,
        const db::eye::Hypothesis& hypothesis,
        db::TId objectId);

    static db::eye::Hypotheses validate(
        const db::eye::Object& object,
        const db::eye::ObjectLocation& location,
        const db::eye::Objects& slaveObjects,
        object::Loader& loader);
};

using LaneHypothesisGenerator
    = BaseHypothesisGenerator<
        LaneHypothesisGeneratorImpl,
        laneHypothesisMetadata,
        db::eye::ObjectType::Sign,
        common::LockId::EyeGenerateLaneHypothesis>;

} // namespace maps::mrc::eye
