#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_hypothesis/include/generator.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/generate_wrong_condition/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_gateway.h>

namespace maps::mrc::eye {

using WrongConditionGeneratorConfig = HypothesisGeneratorConfig;

struct WrongConditionGeneratorImpl {
    static bool appliesToObject(const db::eye::Object& object);

    static bool hasDuplicate(
        pqxx::transaction_base& txn,
        const db::eye::Hypothesis& hypothesis,
        db::TId objectId);

    static db::eye::Hypotheses validate(
        const db::eye::Object& object,
        const db::eye::ObjectLocation& location,
        const db::eye::Objects& slaveObjects,
        object::Loader& loader);
};

using WrongConditionGenerator
    = BaseHypothesisGenerator<
        WrongConditionGeneratorImpl,
        wrongConditionMetadata,
        db::eye::ObjectType::Sign,
        common::LockId::EyeGenerateWrongCondition>;

} // namespace maps::mrc::eye
