#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/metadata.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>

#include <maps/libs/log8/include/log8.h>

#include <string>

namespace maps::mrc::eye {

namespace {

std::map<db::eye::RecognitionType, std::string> RECOGNITION_TYPE_TO_KEY_TXN_ID{
    {db::eye::RecognitionType::DetectSign, "eye.import_detection.txn_id_sign"},
    {db::eye::RecognitionType::DetectTrafficLight, "eye.import_detection.txn_id_traffic_light"},
    {db::eye::RecognitionType::DetectHouseNumber, "eye.import_detection.txn_id_house_number"},
    {db::eye::RecognitionType::DetectRoadMarking, "eye.import_detection.txn_id_road_marking"},
};

} // namespace

void updateImportDetectionTxnId(
    pqxx::transaction_base& txn,
    db::eye::RecognitionType recognitionType,
    db::TId txnId)
{
    std::string keyTxnId = RECOGNITION_TYPE_TO_KEY_TXN_ID.at(recognitionType);
    INFO() << "Update " << keyTxnId << " " << txnId;
    db::MetadataGateway{txn}.upsertByKey(keyTxnId, std::to_string(txnId));
}

db::TId getImportDetectionTxnId(
    pqxx::transaction_base& txn,
    db::eye::RecognitionType recognitionType)
{
    std::string keyTxnId = RECOGNITION_TYPE_TO_KEY_TXN_ID.at(recognitionType);
    return db::MetadataGateway(txn).tryLoadByKey<db::TId>(keyTxnId, 0);
}

} // namespace maps::mrc::eye
