#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/utils.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye {

const std::string SIGNS_DETECTOR_LAST_TRANSACTION_ID = "signs_detector.last_transaction_id";

db::TIds collectFrameIds(const db::eye::Frames& frames) {
    db::TIds ids;
    for (const db::eye::Frame& frame : frames) {
        ids.push_back(frame.id());
    }
    return ids;
}

std::unordered_map<db::TId, db::TId> loadFrameIdToFeatureId(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds)
{
    std::unordered_map<db::TId, db::TId> frameIdToFeatureId;

    auto featureToFrameVec = db::eye::FeatureToFrameGateway(txn).load(
        db::eye::table::FeatureToFrame::frameId.in(frameIds)
    );

    for (const auto& featureToFrame : featureToFrameVec) {
        frameIdToFeatureId[featureToFrame.frameId()] = featureToFrame.featureId();
    }

    return frameIdToFeatureId;
}

db::TIds collectFeatureIds(const std::unordered_map<db::TId, db::TId>& frameIdToFeatureId) {
    db::TIds featureIds;

    for (const auto& [frameId, featureId] : frameIdToFeatureId) {
        featureIds.push_back(featureId);
    }

    return featureIds;
}

std::unordered_map<db::TId, db::Feature> loadFeatureIdToFeature(
    pqxx::transaction_base& txn,
    const db::TIds& featureIds)
{
    db::Features features = db::FeatureGateway(txn).loadByIds(featureIds);

    std::unordered_map<db::TId, db::Feature> featureIdToFeature;
    for (const auto& feature : features) {
        featureIdToFeature.emplace(feature.id(), feature);
    }

    return featureIdToFeature;
}

db::TId getLastSignsDetectorTxnId(pqxx::transaction_base& txn) {
    return db::MetadataGateway(txn).loadByKey<db::TId>(SIGNS_DETECTOR_LAST_TRANSACTION_ID);
}

} // namespace maps::mrc::eye
