#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/house_number_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/traffic_light_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye {

template <typename RecognitionValue>
struct Properties;

// Sign

template <>
struct Properties<db::eye::DetectedSign> {
    using Collection = db::eye::DetectedSigns;

    using Object = db::Sign;
    using ObjectTable = db::table::Sign;
    using ObjectGateway = db::SignGateway;

    using DetectionFeature = db::SignFeature;
    using DetectionFeatureTable = db::table::SignFeature;
    using DetectionFeatureGateway = db::SignFeatureGateway;
};

// Traffic light

template <>
struct Properties<db::eye::DetectedTrafficLight> {
    using Collection = db::eye::DetectedTrafficLights;

    using Object = db::TrafficLight;
    using ObjectTable = db::table::TrafficLight;
    using ObjectGateway = db::TrafficLightGateway;

    using DetectionFeature = db::TrafficLightFeature;
    using DetectionFeatureTable = db::table::TrafficLightFeature;
    using DetectionFeatureGateway = db::TrafficLightFeatureGateway;
};

// House number

template <>
struct Properties<db::eye::DetectedHouseNumber> {
    using Collection = db::eye::DetectedHouseNumbers;

    using Object = db::HouseNumber;
    using ObjectTable = db::table::HouseNumber;
    using ObjectGateway = db::HouseNumberGateway;

    using DetectionFeature = db::HouseNumberFeature;
    using DetectionFeatureTable = db::table::HouseNumberFeature;
    using DetectionFeatureGateway = db::HouseNumberFeatureGateway;
};

// Road marking

template <>
struct Properties<db::eye::DetectedRoadMarking> {
    using Collection = db::eye::DetectedRoadMarkings;

    using Object = db::Sign;
    using ObjectTable = db::table::Sign;
    using ObjectGateway = db::SignGateway;

    using DetectionFeature = db::SignFeature;
    using DetectionFeatureTable = db::table::SignFeature;
    using DetectionFeatureGateway = db::SignFeatureGateway;
};

template <typename RecognitionValue>
using RecognitionValues = typename Properties<RecognitionValue>::Collection;

template <typename RecognitionValue>
using Object = typename Properties<RecognitionValue>::Object;

template <typename RecognitionValue>
using Objects = std::vector<typename Properties<RecognitionValue>::Object>;

template <typename RecognitionValue>
using ObjectTable = typename Properties<RecognitionValue>::ObjectTable;

template <typename RecognitionValue>
using ObjectGateway = typename Properties<RecognitionValue>::ObjectGateway;


template <typename RecognitionValue>
using DetectionFeature = typename Properties<RecognitionValue>::DetectionFeature;

template <typename RecognitionValue>
using DetectionFeatures = std::vector<typename Properties<RecognitionValue>::DetectionFeature>;

template <typename RecognitionValue>
using DetectionFeatureTable = typename Properties<RecognitionValue>::DetectionFeatureTable;

template <typename RecognitionValue>
using DetectionFeatureGateway = typename Properties<RecognitionValue>::DetectionFeatureGateway;

} // namespace maps::mrc::eye
