#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/config.h>

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::mrc::eye {

// Imports information about detected objects.

//Input tables:
// - signs_detect.{sign, sign_feature}
// - house.house_number{, _feature}
// - traffic_light.traffic_light{, _feature}
//Output tables:
// - eye.recognition
//
// Detection will be imported to new
// database if corresponding feature and frame have equal orientation and
// frame does not have any another recognition with same orientation and type.
// If there is no detection for a feature, but its txn id less or equal than
// signs_detector txn id, importer will write empty recognition into database.
//
class DetectionImporter {

public:
    DetectionImporter(const ImportDetectionConfig& config);

    // Return number of imported recognitions
    size_t processBatch(const db::TIds& frameIds);

    // Return number of imported recognitions and flag about processing completion
    std::pair<size_t, bool> processBatchInLoopMode(size_t size);

private:
    void commitIfNeed(pqxx::transaction_base& txn);

    ImportDetectionConfig config_;
};

} // namespace maps::mrc::eye
