#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/tests/fixture.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/config.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, invalid_config_without_pool)
{
    ImportDetectionConfig config;

    EXPECT_TRUE(!isValid(config));

    EXPECT_EQ(config.mrc.commit, false);

    config.mrc.commit = true;
    config.recognitionTypes = {RecognitionType::DetectTrafficLight};
    EXPECT_EQ(config.mrc.commit, true);

    EXPECT_TRUE(!isValid(config));
}

TEST_F(Fixture, valid_config)
{
    ImportDetectionConfig config;

    EXPECT_TRUE(!isValid(config));

    EXPECT_EQ(config.mrc.commit, false);

    config.mrc.commit = false;
    config.mrc.pool = &pool();
    config.recognitionTypes = {RecognitionType::DetectTrafficLight};

    EXPECT_EQ(config.mrc.commit, false);
    EXPECT_EQ(config.mrc.pool, &pool());

    EXPECT_TRUE(isValid(config));
}

} // namespace maps::mrc::eye::tests
