#pragma once

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/house_number_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/traffic_light_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/playground.h>
#include <yandex/maps/mrc/unittest/local_server.h>

namespace maps::mrc::eye::tests {

struct Fixture : testing::Test,
                 unittest::WithUnittestConfig<unittest::DatabaseFixture>
{
    Fixture();

    auto txnHandle() { return pool().masterWriteableTransaction(); }

    db::Features features;
    db::TrafficLights trafficLights;
    db::TrafficLightFeatures trafficLightFeatures;
    db::Signs signs;
    db::SignFeatures signFeatures;
    db::HouseNumbers houseNumbers;
    db::HouseNumberFeatures houseNumberFeatures;

    db::eye::Devices devices;
    db::eye::Frames frames;
    std::vector<db::eye::FeatureToFrame> featureToFrameVec;
    db::eye::Recognitions recognitions;
    db::toloka::Tasks tasks;
    db::eye::RecognitionTasks recognitionTasks;
};

} // namespace maps::mrc::eye::tests
