#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/handler.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, import_traffic_light_detection)
{
    auto txn = txnHandle();

    size_t count = handleImportTrafficLightDetection(*txn, frames);

    EXPECT_EQ(count, 2u);

    Recognitions recognitions = RecognitionGateway(*txn).load(
        table::Recognition::frameId == frames[1].id() &&
        table::Recognition::orientation == static_cast<int16_t>(frames[1].orientation()) &&
        table::Recognition::source == RecognitionSource::Import
    );

    EXPECT_EQ(recognitions.size(), 1u);
    DetectedTrafficLights value = recognitions[0].value<DetectedTrafficLights>();
    EXPECT_EQ(value.size(), 1u);
    EXPECT_EQ(value[0].box, common::ImageBox(30, 30, 40, 40));
    EXPECT_DOUBLE_EQ(value[0].confidence, 1.);

    recognitions = RecognitionGateway(*txn).load(
        table::Recognition::frameId == frames[2].id() &&
        table::Recognition::orientation == static_cast<int16_t>(frames[2].orientation()) &&
        table::Recognition::source == RecognitionSource::Import
    );

    EXPECT_EQ(recognitions.size(), 1u);
    value = recognitions[0].value<DetectedTrafficLights>();
    EXPECT_EQ(value.size(), 0u);
}

TEST_F(Fixture, import_sign_detection)
{
    auto txn = txnHandle();

    size_t count = handleImportSignDetection(*txn, frames);

    EXPECT_EQ(count, 3u);

    Recognitions recognitions = RecognitionGateway(*txn).load(
        table::Recognition::source == RecognitionSource::Import &&
        table::Recognition::type == RecognitionType::DetectSign,
        sql_chemistry::orderBy(table::Recognition::frameId).asc()
    );

    EXPECT_EQ(recognitions.size(), 3u);
    {
        DetectedSigns value = recognitions[0].value<DetectedSigns>();
        EXPECT_EQ(value.size(), 1u);
        EXPECT_EQ(value[0].box, common::ImageBox(10, 10, 20, 20));
        EXPECT_EQ(value[0].type, traffic_signs::TrafficSign::PriorityPriorityRoad);
        EXPECT_DOUBLE_EQ(value[0].typeConfidence, 1.);
        EXPECT_EQ(value[0].temporary, false);
        EXPECT_DOUBLE_EQ(value[0].temporaryConfidence, 1.);
    }
    {
        DetectedSigns value = recognitions[1].value<DetectedSigns>();
        EXPECT_EQ(value.size(), 0u);
    }
    {
        DetectedSigns value = recognitions[2].value<DetectedSigns>();
        EXPECT_EQ(value.size(), 1u);
        EXPECT_EQ(value[0].box, common::ImageBox(40, 40, 50, 50));
        EXPECT_EQ(value[0].type, traffic_signs::TrafficSign::PriorityStop);
        EXPECT_DOUBLE_EQ(value[0].typeConfidence, 1.);
        EXPECT_EQ(value[0].temporary, false);
        EXPECT_DOUBLE_EQ(value[0].temporaryConfidence, 1.);
    }
}

TEST_F(Fixture, import_house_number_detection)
{
    auto txn = txnHandle();

    size_t count = handleImportHouseNumberDetection(*txn, frames);

    EXPECT_EQ(count, 2u);

    Recognitions recognitions = RecognitionGateway(*txn).load(
        table::Recognition::source == RecognitionSource::Import &&
        table::Recognition::type == RecognitionType::DetectHouseNumber,
        sql_chemistry::orderBy(table::Recognition::frameId).asc()
    );

    EXPECT_EQ(recognitions.size(), 2u);
    {
        DetectedHouseNumbers value = recognitions[0].value<DetectedHouseNumbers>();
        EXPECT_EQ(value.size(), 1u);
        EXPECT_EQ(value[0].box, common::ImageBox(10, 10, 20, 20));
        EXPECT_EQ(value[0].number, "1");
        EXPECT_DOUBLE_EQ(value[0].confidence, 1.);
    }
    {
        DetectedHouseNumbers value = recognitions[1].value<DetectedHouseNumbers>();
        EXPECT_EQ(value.size(), 1u);
        EXPECT_EQ(value[0].box, common::ImageBox(40, 40, 50, 50));
        EXPECT_EQ(value[0].number, "2");
        EXPECT_DOUBLE_EQ(value[0].confidence, 1.);
    }
}

TEST_F(Fixture, import_road_marking_detection)
{
    auto txn = txnHandle();

    size_t count = handleImportRoadMarkingDetection(*txn, frames);

    EXPECT_EQ(count, 3u);

    Recognitions recognitions = RecognitionGateway(*txn).load(
        table::Recognition::source == RecognitionSource::Import &&
        table::Recognition::type == RecognitionType::DetectRoadMarking,
        sql_chemistry::orderBy(table::Recognition::frameId).asc()
    );

    EXPECT_EQ(recognitions.size(), 3u);
    {
        DetectedRoadMarkings value = recognitions[0].value<DetectedRoadMarkings>();
        EXPECT_EQ(value.size(), 1u);
        EXPECT_EQ(value[0].box, common::ImageBox(60, 60, 70, 70));
        EXPECT_EQ(value[0].type, traffic_signs::TrafficSign::RoadMarkingLaneDirectionF);
        EXPECT_DOUBLE_EQ(value[0].confidence, 1.);
    }
    {
        DetectedRoadMarkings value = recognitions[1].value<DetectedRoadMarkings>();
        EXPECT_EQ(value.size(), 0u);
    }
    {
        DetectedRoadMarkings value = recognitions[2].value<DetectedRoadMarkings>();
        EXPECT_EQ(value.size(), 0u);
    }
}

} // namespace maps::mrc::eye::tests
