#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/importer.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, import_traffic_light_detection_in_loop)
{
    ImportDetectionConfig config;
    config.mrc.commit = true;
    config.mrc.pool = &pool();
    config.recognitionTypes = {RecognitionType::DetectTrafficLight};

    const size_t batchSize = 1u;

    DetectionImporter importer(config);

    auto checkImport = [&](
        size_t importedNumbers,
        size_t recognitionNumbers,
        bool isFinished)
    {
        auto [count, isFinishedValue] = importer.processBatchInLoopMode(batchSize);

        EXPECT_EQ(count, importedNumbers);
        EXPECT_EQ(isFinishedValue, isFinished);

        Recognitions recognitions = RecognitionGateway(*txnHandle()).load(
            table::Recognition::source == RecognitionSource::Import &&
            table::Recognition::type == RecognitionType::DetectTrafficLight
        );

        EXPECT_EQ(recognitions.size(), recognitionNumbers);
    };

    checkImport(0u, 0u, false);
    checkImport(1u, 1u, false);
    checkImport(1u, 2u, false);
    checkImport(0u, 2u, false);
    checkImport(0u, 2u, false);
    checkImport(0u, 2u, true);
}

} // namespace maps::mrc::eye::tests
