#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/include/utils.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_detection/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, collect_frame_ids)
{
    EXPECT_EQ(
        collectFrameIds({frames[0], frames[1]}),
        db::TIds({frames[0].id(), frames[1].id()})
    );
}

TEST_F(Fixture, collect_feature_ids)
{
    const std::unordered_map<db::TId, db::TId> frameIdToFeatureId{
        {1u, 2u},
        {3u, 4u},
        {5u, 6u}
    };

    const db::TIds expected({2u, 4u, 6u});
    const db::TIds result = collectFeatureIds(frameIdToFeatureId);

    EXPECT_TRUE(
        std::is_permutation(
            expected.begin(), expected.end(),
            result.begin()
        )
    );
}

TEST_F(Fixture, load_feature_id_to_feature)
{
    const auto result = loadFeatureIdToFeature(
        *txnHandle(),
        {features[0].id(), features[1].id()}
    );

    EXPECT_EQ(result.size(), 2u);

    auto feature0It = result.find(features[0].id());
    EXPECT_TRUE(feature0It != result.end());
    EXPECT_EQ(feature0It->second.id(), features[0].id());

    auto feature1It = result.find(features[1].id());
    EXPECT_TRUE(feature1It != result.end());
    EXPECT_EQ(feature1It->second.id(), features[1].id());
}

TEST_F(Fixture, load_frame_id_to_feature_id)
{
    const auto result = loadFrameIdToFeatureId(
        *txnHandle(),
        {frames[0].id(), frames[2].id()}
    );

    EXPECT_EQ(result.size(), 2u);

    auto frame0It = result.find(frames[0].id());
    EXPECT_TRUE(frame0It != result.end());
    EXPECT_EQ(frame0It->second, features[0].id());

    auto frame2It = result.find(frames[2].id());
    EXPECT_TRUE(frame2It != result.end());
    EXPECT_EQ(frame2It->second, features[2].id());
}

} // namespace maps::mrc::eye::tests
