#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_mrc/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::eye {

ImportMrcMetadataManager::ImportMrcMetadataManager(pqxx::transaction_base& txn)
    : MetadataManager("import_mrc", txn)
{}

void ImportMrcMetadataManager::updateFeatureId(db::TId featureId)
{
    const auto key = featureIdKey();

    INFO() << "Update metadata " << key << " " << featureId;
    gateway().upsertByKey(key, std::to_string(featureId));
}

db::TId ImportMrcMetadataManager::getFeatureId() { return gateway().tryLoadByKey<db::TId>(featureIdKey(), 0); }

std::string ImportMrcMetadataManager::featureIdKey() const { return fullKey("feature_id"); }

} // namespace maps::mrc::eye
