#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_mrc/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/pg_locks.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <pqxx/pqxx>

#include <map>
#include <optional>
#include <string>

namespace maps::mrc::eye {

using SourecIdToDevice = std::unordered_map<std::string, db::eye::Device>;

class ImportMrc: public BaseMrcWorkerWithConfig<ImportMrcConfig, common::LockId::EyeImportMrc> {

public:
    using BaseMrcWorkerWithConfig::BaseMrcWorkerWithConfig;

    void processBatch(const db::TIds& featureIds) override;

    // Set last txn id and import time
    bool processBatchInLoopMode(size_t size) override;

private:
    std::optional<std::string> getCameraModel(const db::Feature& feature);

    SourecIdToDevice importDevices(
            pqxx::transaction_base& txn,
            const db::Features& features);

    size_t import(pqxx::transaction_base& txn, const db::TIds& featureIds);
};

} // namespace maps::mrc::eye
