#pragma once

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_mrc/include/import.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/mds.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>

#include <initializer_list>
#include <map>
#include <set>
#include <string>

namespace maps::mrc::eye::tests {

inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture, MdsStubFixture> global;
    return global;
}

struct Fixture: testing::Test {
    Fixture();

    ~Fixture();

    auto& config() { return playground().config(); }

    auto newTxn() { return playground().pool().masterWriteableTransaction(); }

    auto makeWorkerConfig() {
        ImportMrcConfig config;
        config.mrc.pool = &playground().pool();
        config.mrc.commit = true;
        config.mrc.lockFree = true;
        config.mds = &mds;
        return config;
    }

    db::TId featureIdAt(size_t index) const;
    db::TIds featureIdsAt(std::initializer_list<size_t> indexes) const;

    std::set<db::TId> frameIdSetAt(std::initializer_list<size_t> indexes);

    std::map<std::string, db::eye::FeatureSourceToDevice> loadDeviceMatching();
    std::map<db::TId, db::eye::FeatureToFrame> loadFrameMatching();

    std::map<db::TId, db::eye::Device> loadDeviceMap();
    std::map<db::TId, db::eye::Frame> loadFrameMap();
    std::map<db::TId, db::eye::FrameLocation> loadFrameLocationMap();
    std::map<db::TId, db::eye::FramePrivacy> loadFramePrivacyMap();

    db::TId getDeviceId(const std::string& sourceId);
    db::TId getFrameId(db::TId featureId);

    const db::Features features;
    mds::Mds mds;
};

} // namespace maps::mrc::eye::tests
