#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

#include <maps/libs/geolib/include/units.h>

namespace maps::mrc::eye {

const geolib3::Degrees PANORAMA_FRAME_DEVIATIONS[] = {
    geolib3::Degrees{0},
    geolib3::Degrees{60},
    geolib3::Degrees{120},
    geolib3::Degrees{180},
    geolib3::Degrees{240},
    geolib3::Degrees{300},
};

const std::size_t PANORAMA_FRAME_DEVIATIONS_SIZE =
    sizeof(PANORAMA_FRAME_DEVIATIONS) / sizeof(*PANORAMA_FRAME_DEVIATIONS);

constexpr geolib3::Degrees PANORAMA_FRAME_HORIZONTAL_FOV{70};
constexpr geolib3::Degrees PANORAMA_FRAME_TILT{0};
const common::ImageOrientation PANORAMA_FRAME_ORIENTATION{common::Rotation::CW_0};
const common::Size PANORAMA_FRAME_SIZE{1920, 1080};

} // namespace maps::mrc::eye
