#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_panorama_frame/include/metadata.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::eye {

ImportPanoramaFrameMetadataManager::ImportPanoramaFrameMetadataManager(
    pqxx::transaction_base& txn)
    : MetadataManager("import_panorama_frame", txn)
{ }

void ImportPanoramaFrameMetadataManager::updateOrderNum(std::uint32_t orderNum)
{
    const auto key = orderNumKey();

    INFO() << "Update metadata " << key << " " << orderNum;
    gateway().upsertByKey(key, std::to_string(orderNum));
}

void ImportPanoramaFrameMetadataManager::updateSessionId(std::uint64_t sessionId)
{
    const auto key = sessionIdKey();

    INFO() << "Update metadata " << key << " " << sessionId;
    gateway().upsertByKey(key, std::to_string(sessionId));
}

std::uint64_t ImportPanoramaFrameMetadataManager::getSessionId()
{
    return gateway().tryLoadByKey<std::uint64_t>(sessionIdKey(), 0);
}

std::uint32_t ImportPanoramaFrameMetadataManager::getOrderNum()
{
    return gateway().tryLoadByKey<std::uint64_t>(orderNumKey(), 0);
}

std::string ImportPanoramaFrameMetadataManager::sessionIdKey() const
{
    return fullKey("session_id");
}

std::string ImportPanoramaFrameMetadataManager::orderNumKey() const
{
    return fullKey("order_num");
}

} // namespace maps::mrc::eye
