#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/point.h>

#include <functional>
#include <map>
#include <optional>
#include <vector>

namespace maps::mrc::eye {

const auto LOAD_PANORAMAS_SINCE = chrono::parseSqlDateTime("2020-01-01 00:00:00");

struct PanoramaDescription {
    std::string oid;
    chrono::TimePoint date;
    std::uint64_t sessionId;
    std::uint32_t orderNum;
    geolib3::Point2 geodeticPos; // lon, lat
    geolib3::Heading course;
};

using PanoramaDescriptions = std::vector<PanoramaDescription>;

// This class provides access to YT tables there panoramas are released into.
//
// NOTE: Don't forget to call at least NYT::JoblessInitialize() before using
//       an instance of this class.
class YtPanoramaLoader final {
public:
    YtPanoramaLoader(YtPanoramaLoader&&) = default;
    YtPanoramaLoader& operator=(YtPanoramaLoader&&) = default;
    YtPanoramaLoader(const YtPanoramaLoader&) = delete;
    YtPanoramaLoader& operator=(const YtPanoramaLoader&) = delete;

    YtPanoramaLoader(const common::YtConfig& ytConfig, NYT::IClientPtr ytClient);

    std::uint64_t loadRevision() const;

    // Load panorama descriptions from YT tables
    // https://yt.yandex-team.ru/hahn/navigation?path=//home/maps/streetview/stable/release
    PanoramaDescriptions loadPanoramas();

    NYT::IClientPtr ytClient() const;

    TString panoramasWorkingDir() const;

    TString descriptionPath() const;

private:
    common::YtConfig ytConfig_;
    NYT::IClientPtr ytClient_;
};

} // namespace maps::mrc::eye
