#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/move.h>

#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/vector.h>

namespace maps::mrc::eye {

Eigen::Vector3d toMoveVector(geolib3::Heading heading)
{
    const geolib3::Vector2 vector = geolib3::Direction2(heading).vector();
    return Eigen::Vector3d(vector.x(), vector.y(), 0);
}

std::optional<geolib3::Heading> toHeading(const Eigen::Vector3d& move)
{
    const geolib3::Vector2 vector(move.x(), move.y());

    constexpr double EPS = 1e-6;
    if (geolib3::length(vector) < EPS) {
        return std::nullopt;
    }

    return geolib3::Direction2(vector).heading();
}

geolib3::Degrees absDiffInDegrees(const Eigen::Vector3d& lhs, const Eigen::Vector3d& rhs)
{
    const double angle = std::abs(std::acos(lhs.dot(rhs)));

    return geolib3::toDegrees(geolib3::Radians(angle));
}

} // namespace maps::mrc::eye