#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>

#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/units.h>

#include <contrib/libs/eigen/Eigen/Geometry>

namespace maps::mrc::eye {

Eigen::Matrix3d makeRotationMatrix(
        const Eigen::Vector3d& x,
        const Eigen::Vector3d& y,
        const Eigen::Vector3d& z);

Eigen::Quaterniond toRotation(
        const geolib3::Heading& heading,
        const common::ImageOrientation& orientation);

Eigen::Quaterniond toRotation(const std::vector<double>& cameraRodrigues);

struct RotationDecomposition {
    geolib3::Heading heading;
    common::ImageOrientation orientation;
    geolib3::Degrees pitch;
};

RotationDecomposition decomposeRotation(const Eigen::Quaterniond& rotation);

geolib3::Degrees absDiffInDegrees(const Eigen::Quaterniond& lhs, const Eigen::Quaterniond& rhs);

} // namespace maps::mrc::eye
