#include <maps/wikimap/mapspro/services/mrc/eye/lib/monitoring/include/common.h>

#include <library/cpp/iterator/mapped.h>
#include <util/string/join.h>


namespace maps::mrc::eye {

std::string collectNameList(const MonitoringCheckByName& checkByName)
{
    const auto names = MakeMappedRange(
        checkByName,
        [&](const auto& pair) {
            return pair.first;
        }
    );

    return JoinSeq(",", names);
}

} // namespace maps::mrc::eye